/***************************************************************/
/*                                                             */
/*      PROJECT NAME :  Cart01                              */
/*      FILE         :  Cart01.c                            */
/*      DESCRIPTION  :  Main Program                           */
/*      ジョイスティック用                                                       */
/*      This file was generated by e2 studio.                  */
/*                                                             */
/***************************************************************/

#include <iodefine.h>

//	存在しないpinに対応するポート（６４ピン）
 #define DEF_P0PDR          0x80        /* non-existent pin: P07 */
 #define DEF_P1PDR          0x0C        /* non-existent pin: P12, P13 */
 #define DEF_P2PDR          0x3F        /* non-existent pin: P20 to P25 */
 #define DEF_P3PDR          0x18        /* non-existent pin: P33, P34 */
 #define DEF_P4PDR          0xA0        /* non-existent pin: P45, P47 */
 #define DEF_P5PDR          0x0F        /* non-existent pin: P50 to P53 */
 #define DEF_PAPDR          0xA4        /* non-existent pin: PA2, PA5, PA7 */
 #define DEF_PBPDR          0x14        /* non-existent pin: PB2, PB4 */
 #define DEF_PCPDR          0x03        /* non-existent pin: PC0, PC1 */
 #define DEF_PDPDR          0xFF        /* non-existent pin: PD0 to PD7 */
 #define DEF_PEPDR          0xC0        /* non-existent pin: PE6, PE7 */
 #define DEF_PHPDR          0x00        /* non-existent pin: none */
 #define DEF_PJPDR          0x0A        /* non-existent pin: PJ1, PJ3 */

#define CYCLETIME 	8000;        //cycletime 752usec:1.33KHz
#define ROT_SW		PORT5.PIDR.BIT.B4

void R_INIT_NonExistentPort(void){	//存在しないpinの内部ポートを出力に固定する
    PORT0.PDR.BYTE = PORT0.PDR.BYTE | DEF_P0PDR;
    PORT1.PDR.BYTE = PORT1.PDR.BYTE | DEF_P1PDR;
    PORT2.PDR.BYTE = PORT2.PDR.BYTE | DEF_P2PDR;
    PORT3.PDR.BYTE = PORT3.PDR.BYTE | DEF_P3PDR;
    PORT4.PDR.BYTE = PORT4.PDR.BYTE | DEF_P4PDR;
    PORT5.PDR.BYTE = PORT5.PDR.BYTE | DEF_P5PDR;
    PORTA.PDR.BYTE = PORTA.PDR.BYTE | DEF_PAPDR;
    PORTB.PDR.BYTE = PORTB.PDR.BYTE | DEF_PBPDR;
    PORTC.PDR.BYTE = PORTC.PDR.BYTE | DEF_PCPDR;
//  PORTD.PDR.BYTE = PORTD.PDR.BYTE | DEF_PDPDR;
    PORTE.PDR.BYTE = PORTE.PDR.BYTE | DEF_PEPDR;
    PORTH.PDR.BYTE = PORTH.PDR.BYTE | DEF_PHPDR;
    PORTJ.PDR.BYTE = PORTJ.PDR.BYTE | DEF_PJPDR;
}


void pullup(void){			//未使用端子プルアップ
	PORT0.PCR.BYTE = 0x28;
	PORT1.PCR.BYTE = 0xf0;
	PORT2.PCR.BYTE = 0xc0;
	PORT3.PCR.BYTE = 0x27;	//00100111
/*
	PORT3.PCR.BIT.B0 == 1;	//RXD1
	PORT3.PCR.BIT.B1 == 1;
	PORT3.PCR.BIT.B2 == 1;
	PORT3.PCR.BIT.B5 == 1;	//NMI
//	PORT3.PCR.BIT.B6 == 0;	//Clock:EXTAL
//	PORT3.PCR.BIT.B7 == 0;	//Clock:XTAL
*/
	PORT4.PCR.BYTE = 0x58;	//01011000:0-2 AD入力
	PORT5.PCR.BYTE = 0x30;
	PORTA.PCR.BYTE = 0x5b;
	PORTB.PCR.BYTE = 0xeb;
	PORTC.PCR.BYTE = 0xfc;
	PORTE.PCR.BYTE = 0x3f;
}


void init_adc(){
    //Port設定
    PORT4.PMR.BYTE = 0x07;                  //Port40,41,42を周辺機能とする
    PORT4.PDR.BYTE = 0x00;                  //入力端子

	SYSTEM.PRCR.WORD = 0xa50b; 				//プロテクトの解除 クロックを選択可能にする(0xa502：第２ビットを上げれば良い）
    SYSTEM.MSTPCRA.BIT.MSTPA17 = 0; 		//S12ADモジュールを有効化:AD変換可能
	SYSTEM.PRCR.WORD = 0xa500; 				//変更不可に戻す

    S12AD.ADCSR.BIT.ADCS = 0x2;             //連続スキャンモード
    S12AD.ADANSA.WORD = 0x0007;             //AN000-003を有効にする
    S12AD.ADSSTR0 = 0xFF;                   //サンプリング時間255ADCLKクロック(=10us，多分)
    S12AD.ADCSR.BIT.ADST = 0x1;             //AD変換スタート
}

void MTUset(void){

//	PWM波形を出力する。それぞれのチャンネルに対し、TGRAにパルス周期・TGRDにパルス幅をセットする。
//	周期とは不同期にTGRDを書き換えると次のカウントアップ時にパルス幅が新しい値に書き換わる。


// MTUの起動設定
    SYSTEM.PRCR.WORD = 0xa50b; //プロテクトの解除 変更可能にする
    SYSTEM.MSTPCRA.BIT.MSTPA9 = 0; //ユニット１起動

// Ch0の設定
    PORTB.PMR.BIT.B3 = 1;		//PB3端子を周辺機器端子として使用する
    MPC.PB3PFS.BIT.PSEL = 1;	//PB3端子をMTIOC0Aに割り当てる

    MTU0.TCR.BIT.TPSC = 0;    //周辺モジュールクロックの1分周
    MTU0.TCR.BIT.CKEG = 0;    //立ち上がりエッジ
    MTU0.TCR.BIT.CCLR = 1;    //TGRAのコンペアマッチでTCNTクリア

    MTU0.TMDR.BIT.MD = 0x02;    // PWMモード1で動作
    MTU0.TMDR.BIT.BFB = 1;        //TGRAとTGRCはバッファ動作

    MTU0.TIORH.BIT.IOA = 6;        //0110    H-H
    MTU0.TIORH.BIT.IOB = 5;        //0101　H-L
    MTU0.TGRA = CYCLETIME;        //cycletime 1msec

    MTU0.TBTM.BIT.TTSB = 1; 	//TGRC->A　の転送タイミング　TCNTクリア時
    MTU.TSTR.BIT.CST0 = 1;        //カウントスタート

//　Ch3の設定
    PORT1.PMR.BIT.B4 = 1;		//P17端子を周辺機器端子として使用す
    MPC.P14PFS.BIT.PSEL = 1;	//P17端子をMTIOC3Aに割り当てる

    MTU3.TCR.BIT.TPSC = 0;    //周辺モジュールクロックの1分周
    MTU3.TCR.BIT.CKEG = 0;    //立ち上がりエッジ
    MTU3.TCR.BIT.CCLR = 1;    //TGRAのコンペアマッチでTCNTクリア

    MTU3.TMDR.BIT.MD = 0x02;    // PWMモード1で動作
    MTU3.TMDR.BIT.BFB = 1;        //TGRAとTGRCはバッファ動作

    MTU3.TIORH.BIT.IOA = 6;        //0110    H-H
    MTU3.TIORH.BIT.IOB = 5;        //0101　H-L
    MTU3.TGRA = CYCLETIME;        //cycletime 1msec
//    MTU3.TGRD = width;            //width Min0.5msec Max1.5msec
    MTU3.TBTM.BIT.TTSB = 1; 	//TGRC->A　の転送タイミング　TCNTクリア時
    MTU.TSTR.BIT.CST3 = 1;        //カウントスタート

    SYSTEM.PRCR.WORD = 0xa500; //変更禁止に戻す
}



/*
********************************************************************************
RX220はコールドスタート時のクロックが125KHｚに設定されている。
通常動作のクロックに切り替えるには操作が必要になる。
メイン外部発振端子XTAL及びEXTALは機能切り替えでPORT3-6、PORT3-7と排他的に使用する。（端子数が足りないので重畳されている）
メイン外部発振を使用するとPORT3-6,7は使用できない。（内臓発振器を使用可能）
秋月のボードではPORT3-6,7は外部に結線されていない。発振専用になっている。
RX621ではコールドスタートで通常クロックになり、外部発振端子は専用なのでこの操作は不要（内部発振器は存在しない）
*/
void clockset(void){
	SYSTEM.PRCR.WORD = 0xa50b; //システムプロテクト解除（クロックを選択可能にする）
	SYSTEM.SCKCR.BIT.PCKB = 0x01; //周辺モジュールのクロックはシステムクロックの2分周とにする
	SYSTEM.SCKCR.BIT.ICK = 0x00; //システムクロックはデフォルト設定：１分周とする

	SYSTEM.MOSCCR.BYTE = 0; //メインクロック発振器動作
	SYSTEM.SOSCCR.BYTE = 0; //サブクロック発振器動作
	SYSTEM.SCKCR3.WORD = 0x0200; //大元のクロックにメインクロックを使用する。

//	内臓発振器を使用する場合
//	SYSTEM.SCKCR3.BIT.CKSEL=1; //HOCOをクロックソースに設定
//	SYSTEM.HOCOCR.BIT.HCSTP = 0; //HOCO動作
//	SYSTEM.HOCOCR2.BIT.HCFRQ = 0; //HOCOのク ロック選択 0**32MHz

	SYSTEM.PRCR.WORD = 0xa500; //システムプロテクト設定（クロックを変更不可にする）
}

void enable_functionselect(void){		// 端子機能選択許可
	MPC.PWPR.BIT.B0WI = 0; 				//PWPR.PFSWEライトプロテクト解除
	MPC.PWPR.BIT.PFSWE = 1;				//上記と組み合わせ端子機能選択可能にする。
}

void disable_functionselect(void){		//	端子機能選択禁止
	MPC.PWPR.BIT.B0WI = 1; 				//PWPR.PFSWEライトプロテクト設定
	MPC.PWPR.BIT.PFSWE = 0;				//上記と組み合わせ端子機能選択禁止にする。
}

//******************************************************************************
//	ここからメインルーチン
int main(void) {
//	初期設定
//__builtin_rx_clrpsw('I');割り込み受付禁止
	clockset();
	enable_functionselect();	// 端子機能選択許可
	init_adc(); //ADC start
	MTUset();	//PWM開始
	pullup();
	disable_functionselect();	// 端子機能選択禁止
	R_INIT_NonExistentPort();	//存在しないポートの設定：有効ポート設定後にコール

	PORTH.PDR.BYTE=0xff;	//Ry0-3
	PORTH.PODR.BYTE=0x0f;

	int spd = 0;
	int spd_R = 0;
	int spd_L = 0;
	int dir = 0;
	int trim;
	int FR_dir;

//	spd = S12AD.ADDR0;
//	dir = S12AD.ADDR1;
//	trim = S12AD.ADDR2;

	//__builtin_rx_setpsw('I');CPU割り込み受付許可
	//	初期設定終了
	//*************************************************************************

while(1){
	spd = S12AD.ADDR0;
	dir = S12AD.ADDR1;
	trim = S12AD.ADDR2;

//	通常モード　ROT_SWは通常<=>旋回の切替SW
while(ROT_SW == 1){

	spd = S12AD.ADDR0;
	dir = S12AD.ADDR1;
	trim = S12AD.ADDR2;

	if(spd<=2047){				//ジョイスティック 後退方向
		spd=(2048-spd)*3;
		FR_dir = 0;

	}
	else if(2048<=spd){			//前進方向
		spd=(spd-2048)*3;
		FR_dir = 1;


	}


	//速度カーブ変更（低速ー高速での変化率を変える）
		spd = spd - 300;
		if(spd<0) spd = 0;

		if(2000<spd && spd<=4000)
			spd = (spd - 2000) * 1.4 + 2000;
		else if(4000 < spd)
			spd = (spd - 4000) * 2 + 4705;

		spd_R = spd;
		spd_L = spd;

//	方向微調整（直進性微調整VR）
		if(trim<2000){
 		trim=(2048-trim);
 		spd_R = spd_R + (spd_R*trim/2048)*0.1;
 		if(spd_R<0)	spd_R=0;
 		if(8000<spd_R)	spd_R=8000;

 		spd_L = spd_L - (spd_L*trim/2048)*0.1;
 		if(spd_L<0)		spd_L=0;
 		if(8000<spd_L)	spd_L=8000;
 	}
 	else if(trim>2096){
 		trim=(trim-2048);
 		spd_R = spd_R - (spd_R*trim/2048)*0.1;
 		if(spd_R<0)		spd_R=0;
 		if(8000<spd_R)	spd_R=8000;

 		spd_L = spd_L + (spd_L*trim/2048)*0.1;
 		if(spd_L<0)		spd_L=0;
 		if(8000<spd_L)	spd_L=8000;
 	}
//
//　操舵

 //if(ROT_SW == 1){
	if(dir<1848){		//ジョイスティックが右の場合：右に曲がる=右モーターを止める
		dir=(2048-dir)*1.2;
		spd_L = spd_L + spd_L*dir/2048;		//左モーターの回転を上げる
		if(spd_L<300){						//起動電力を更に下回ると低速時モーターを止める
			spd_L=0;
			PORTH.PODR.BIT.B2 =0;
			PORTH.PODR.BIT.B3 =0;
		}
		if(7492<spd_L)	spd_L=7492;

		spd_R = spd_R - spd_R*dir/2048;		//右モーターの回転を下げる
		if(spd_R<300){						//起動電力を更に下回ると低速時モーターを止める
			spd_R=0;
			PORTH.PODR.BIT.B0 =0;
			PORTH.PODR.BIT.B1 =0;
		}
		if(7492<spd_R)	spd_R=7492;
	}

	else if(2248<dir){		//ジョイスティックが左の場合：左に曲がる=左モーターを止める
		dir=(dir-2048)*1.2;



		spd_R = spd_R + spd_R*dir/2048;		//右モーターの回転を上げる
		if(spd_R<300){						//起動電力を更に下回ると低速時モーターを止める
			spd_R=0;
			PORTH.PODR.BIT.B0 =0;
			PORTH.PODR.BIT.B1 =0;
		}
		if(7492<spd_R)	spd_R=7492;

		spd_L = spd_L - spd_L*dir/2048;		//左モーターの回転を下げる
		if(spd_L<300) {						//起動電力を更に下回ると低速時モーターを止める
			spd_L=0;
			PORTH.PODR.BIT.B2 =0;
			PORTH.PODR.BIT.B3 =0;
		}
		if(7492<spd_L)	spd_L=7492;
	}

	//*************モーター起動************ 最低速はMAXの1/20
		if(spd_R > 400 && FR_dir == 0){
			PORTH.PODR.BIT.B0 =1;	// Ry1　右モーターCCW
			PORTH.PODR.BIT.B1 =0;	// Ry2　右モーターCCW
		}
		if(spd_L > 400 && FR_dir == 0){
			PORTH.PODR.BIT.B2 =1;	// Ry1　左モーターCCW
			PORTH.PODR.BIT.B3 =0;	// Ry2　左モーターCCW
		}
		if(spd_R > 400 && FR_dir == 1){
			PORTH.PODR.BIT.B0 =0;	// Ry1　右モーターCW
			PORTH.PODR.BIT.B1 =1;	// Ry2　右モーターCW
		}
		if(spd_L > 400 && FR_dir == 1){
			PORTH.PODR.BIT.B2 =0;	// Ry1　左モーターCW
			PORTH.PODR.BIT.B3 =1;	// Ry2　左モーターCW
		}

		if(300>spd){		//停止：ジョイスティック0点に不感帯を設ける*****************************************
			spd=0;
			PORTH.PODR.BIT.B0 =0;
			PORTH.PODR.BIT.B1 =0;
			PORTH.PODR.BIT.B2 =0;	//
			PORTH.PODR.BIT.B3 =0;
		}

	MTU0.TGRD = spd_R;
	MTU3.TGRD = spd_L;

}

//	*****  その場旋回  ****


if(ROT_SW == 0 && spd_R == 0 && spd_L == 0 && 1848<dir && dir<2284){ //停止中のみその場旋回モードに入る）
	while(ROT_SW == 0){

	spd = S12AD.ADDR0;
	dir = S12AD.ADDR1;
	trim = S12AD.ADDR2;
//	rot_sw = PORT5.PIDR.BIT.B4;

		if(dir<1848){
			dir=2*(2048-dir);
			PORTH.PODR.BIT.B0 =1;
			PORTH.PODR.BIT.B1 =0;
			PORTH.PODR.BIT.B2 =0;	//
			PORTH.PODR.BIT.B3 =1;
			spd_R = dir;
			spd_L = dir;

		}
		else if(dir>2248){
			dir=2*(dir-2048);
			PORTH.PODR.BIT.B0 =0;
			PORTH.PODR.BIT.B1 =1;
			PORTH.PODR.BIT.B2 =1;	//
			PORTH.PODR.BIT.B3 =0;
			spd_R = dir;
			spd_L = dir;
		}
		else{
			PORTH.PODR.BIT.B0 =0;
			PORTH.PODR.BIT.B1 =0;
			PORTH.PODR.BIT.B2 =0;	//
			PORTH.PODR.BIT.B3 =0;
			spd_R = 0;
			spd_L = 0;
		}

    MTU0.TGRD = spd_R;
    MTU3.TGRD = spd_L;

	}

	PORTH.PODR.BIT.B0 =0;
	PORTH.PODR.BIT.B1 =0;
	PORTH.PODR.BIT.B2 =0;	//
	PORTH.PODR.BIT.B3 =0;
	spd_R = 0;
	spd_L = 0;
}

}
return 0;

}
