/***************************************************************/
/*                                                             */
/*      PROJECT NAME :  RailwayModelPowerpack01                */
/*      FILE         :  RailwayModelPowerpack01.c              */
/*      DESCRIPTION  :  Main Program                           */
/*                                                             */
/*      This file was generated by e2 studio.                  */
/*                                                             */
/***************************************************************/

/***************************************************************/
/*                                                             */
/*      PROJECT NAME :  PowerPack                         */
/*      FILE         :  PowerPack_20230211.c                   */
/*      DESCRIPTION  :  Main Program                           */
/*                                                             */
/*      This file was generated by e2 studio.                  */
/*                                                             */
/***************************************************************/

#include <iodefine.h>
//#include"RX-I2C.h"

#define RS					PORTE.PODR.BIT.B4	//CN1-11
#define EN					PORTE.PODR.BIT.B5	//CN1-12
#define DB4					PORTE.PODR.BIT.B0	//CN1-7
#define DB5					PORTE.PODR.BIT.B1	//CN1-8
#define DB6					PORTE.PODR.BIT.B2	//CN1-9
#define DB7					PORTE.PODR.BIT.B3	//CN1-10

#define LCD_CMD				0		// LCD Command Set
#define LCD_DATA			1		// LCD Data Set
#define CYCLETIME 			8000;   // PWMcycletime 752usec:1.33KHz

//	プロトタイプ
void wait( unsigned int loop);
void write_lcd(unsigned char code, unsigned char rs);
void locate(int x, int y);
void write_char(unsigned char c);
void write_str(char *s);
void InitLcd(void);

void itoa(char out_str[],unsigned int in_i);
void initIrqSwitch(void);
void clockset(void);

void enable_PWPR(void);
void disable_PWPR(void);
void R_INIT_NonExistentPort(void);		//存在しないpinに対応するポートを停止する
void pullup(void);
void init_adc(void);
void rtc_set(void);

void MTUset(void);
void enable_functionselect(void);
void disable_functionselect(void);
void init_CMT(void);
//変数
unsigned char	out_str[10];//エンコーダー入力値変換->表示用文字変換
int power,power2,power3;
int interval,interval2,interval3;
volatile unsigned char psw1,sw1;

int main(void) {
	clockset();
	enable_functionselect();
	R_INIT_NonExistentPort();
	rtc_set();
	init_adc();

    InitLcd();					//	LCD 初期化
	MTUset();
	disable_functionselect();
	init_CMT();
//    __builtin_rx_setpsw('I');
//    __builtin_rx_clrpsw('I');
//-----------------------------------------------------------------------
//	1行目表示
//-----------------------------------------------------------------------

    locate(0, 1);
    write_str("PWM");
    locate(0, 2);
    write_str("Int.");

    int t;
    for(t=0;t<=100;t++){
        wait(1000);}
    PORT0.PDR.BYTE = 0xff;
    PORTB.PDR.BYTE = 0xff;

    while(1) {
    	psw1 = PORTH.PIDR.BIT.B3;	//bit0~3を確認 運転OFF：スタートボタン:ON
    	while(psw1 == 0){
    		PORT0.PODR.BIT.B3 = 1;
    		PORT0.PODR.BIT.B5 = 0;
    		wait(10000);
    		PORT0.PODR.BIT.B3 = 0;
    		PORT0.PODR.BIT.B5 = 1;
    		wait(10000);
    		psw1 = PORTH.PIDR.BIT.B3;
    	}
    	sw1 = PORTH.PIDR.BYTE & 0x03;

    	if(sw1 == 1){
    		PORT0.PODR.BIT.B3 = 1;
    		PORT0.PODR.BIT.B5 = 0;
    	}
    	else if(sw1==2){
    		PORT0.PODR.BIT.B3 = 0;
    		PORT0.PODR.BIT.B5 = 1;
    	}
    	else if(sw1==3){
    		PORT0.PODR.BIT.B3 = 0;
    		PORT0.PODR.BIT.B5 = 0;
    	}
    	wait(2000);

    	int temp_ad0a,temp_ad1a,temp_ad2a,temp_ad0b,temp_ad1b,temp_ad2b,temp_ad0c,temp_ad1c,temp_ad2c;
    	S12AD.ADCSR.BIT.ADST = 0x1;             //AD変換スタート
    	while(S12AD.ADCSR.BIT.ADST == 1)
    		;
    	temp_ad0a = S12AD.ADDR0;
    	temp_ad1a = S12AD.ADDR1;
    	temp_ad2a = S12AD.ADDR2;

    	S12AD.ADCSR.BIT.ADST = 0x1;             //AD変換スタート
    	while(S12AD.ADCSR.BIT.ADST == 1)
    		;
    	temp_ad0b = S12AD.ADDR0;
    	temp_ad1b = S12AD.ADDR1;
    	temp_ad2b = S12AD.ADDR2;

    	S12AD.ADCSR.BIT.ADST = 0x1;             //AD変換スタート
    	while(S12AD.ADCSR.BIT.ADST == 1)
    		;
    	temp_ad0c = S12AD.ADDR0;
    	temp_ad1c = S12AD.ADDR1;
    	temp_ad2c = S12AD.ADDR2;

    	power = (temp_ad0a+temp_ad0b+temp_ad0c)/3;			//メインボリューム12bit値

    	power2 = power*101/4096;						//メインデューティ％表示
    	power3 = power2*CYCLETIME;
    	power3 = power3/100;							//メイン

    	interval = (temp_ad1a+temp_ad1b+temp_ad1c)/3;	//サブVR12bit値 (1-3端子入れ替え 右回し0，左4095)
    	interval2 = interval*2 - power*1.5;			//インターバルの基礎周期　MTU3A <- 20580 PLCK:10MHz 2058mS
    	if(interval2 < 0)
    		interval2 = 0;
    	interval3 = interval2/2+10;		//インターバルのON時間　MAX:385 MIN:100

    	MTU3.TGRC = interval2;
    	MTU3.TGRD = interval3;

    	int t;
    	for(t=0;t<=100;t++){
    		wait(2000);
    	}

    	MTU.TSTR.BIT.CST0 = 1;        	//MTU カウントスタート
    	MTU.TSTR.BIT.CST3 = 1;        	//MTU カウントスタート
    	CMT.CMSTR0.BIT.STR0 = 1;		//CMT カウントスタート
    }
}
//********************************************************************************
//-----------------------------------------------------------------------
//メイン終了
//-----------------------------------------------------------------------
//********************************************************************************
void rtc_set(void){

	SYSTEM.PRCR.WORD = 0xa50b;
	SYSTEM.SOSCCR.BIT.SOSTP = 1;
	while(SYSTEM.SOSCCR.BIT.SOSTP == 0)
		;
	RTC.RCR3.BIT.RTCEN = 0;
	while(RTC.RCR3.BIT.RTCEN == 1)
		;
	RTC.RCR2.BIT.START = 0;
	while(	RTC.RCR2.BIT.START == 1)
		;
	RTC.RCR3.BIT.RTCDV = 6;						//標準駆動能力
	RTC.RCR3.BIT.RTCEN = 1;						//サブクロック発振開始
	wait(1000);

	RTC.RCR2.BIT.CNTMD = 1;
	while(RTC.RCR2.BIT.CNTMD == 0)
		;
	RTC.RCR2.BIT.RESET = 1;
	while(RTC.RCR2.BIT.RESET == 1)
		;

	RTC.R64CNT.BYTE = 0x00;
	RTC.BCNT0.BYTE = 0x00;
	RTC.BCNT1.BYTE = 0x00;
	RTC.BCNT2.BYTE = 0x00;
	RTC.BCNT3.BYTE = 0x00;
	RTC.BCNT0AR.BYTE = 0x05;
	RTC.BCNT0AER.BYTE = 0x05;

	RTC.RCR1.BIT.AIE = 1;
//	RTC.RCR1.BIT.PES = 8;						//コメントアウトするとAIEが１にならない。割り込みがかからない。
	ICU.IR[92].BYTE = 0x00;
	RTC.RCR2.BIT.START = 1;
	while(RTC.RCR2.BIT.START == 0)
		;
//	ICU.IER.BIT.IEN0 = 1;
	IEN(RTC,ALM) = 1;
	IPR(RTC,ALM) = 10;
	SYSTEM.PRCR.WORD = 0xa500;
}



//************************************************
//    CPU初期設定
//************************************************

//存在しないpinの内部ポートを出力に固定（停止）する
void R_INIT_NonExistentPort(void){
    PORT0.PDR.BYTE = PORT0.PDR.BYTE | 0x80;        /* non-existent pin: P07 */
    PORT1.PDR.BYTE = PORT1.PDR.BYTE | 0x0C;        /* non-existent pin: P12, P13 */
    PORT2.PDR.BYTE = PORT2.PDR.BYTE | 0x3F;        /* non-existent pin: P20 to P25 */
    PORT3.PDR.BYTE = PORT3.PDR.BYTE | 0x18;        /* non-existent pin: P33, P34 */
    PORT4.PDR.BYTE = PORT4.PDR.BYTE | 0xA0;        /* non-existent pin: P45, P47 */
    PORT5.PDR.BYTE = PORT5.PDR.BYTE | 0x0F;        /* non-existent pin: P50 to P53 */
    PORTA.PDR.BYTE = PORTA.PDR.BYTE | 0xA4;        /* non-existent pin: PA2, PA5, PA7 */
    PORTB.PDR.BYTE = PORTB.PDR.BYTE | 0x14;        /* non-existent pin: PB2, PB4 */
    PORTC.PDR.BYTE = PORTC.PDR.BYTE | 0x03;        /* non-existent pin: PC0, PC1 */
//  PORTD.PDR.BYTE = PORTD.PDR.BYTE | 0xFF        /* non-existent pin: PD0 to PD7 */
    PORTE.PDR.BYTE = PORTE.PDR.BYTE | 0xC0;        /* non-existent pin: PE6, PE7 */
    PORTH.PDR.BYTE = PORTH.PDR.BYTE | 0x00;        /* non-existent pin: none */
    PORTJ.PDR.BYTE = PORTJ.PDR.BYTE | 0x0A;        /* non-existent pin: PJ1, PJ3 */
}

void pullup(void){						//未使用入力端子プルアップ　P3-6,7に注意
	PORT0.PCR.BYTE = 0x28;
	PORT1.PCR.BYTE = 0xf0;
	PORT2.PCR.BYTE = 0xc0;
	PORT3.PCR.BYTE = 0x27;				//00100111
/*
	PORT3.PCR.BIT.B0 == 1;				//RXD1
	PORT3.PCR.BIT.B1 == 1;
	PORT3.PCR.BIT.B2 == 1;
	PORT3.PCR.BIT.B5 == 1;				//NMI
//	PORT3.PCR.BIT.B6 == 0;				//Clock:EXTAL
//	PORT3.PCR.BIT.B7 == 0;				//Clock:XTAL
*/
	PORT4.PCR.BYTE = 0x58;				//01011000:0-2 AD入力
	PORT5.PCR.BYTE = 0x30;
	PORTA.PCR.BYTE = 0x5b;
	PORTB.PCR.BYTE = 0xeb;
	PORTC.PCR.BYTE = 0xfc;
	PORTE.PCR.BYTE = 0x3f;
}

void enable_PWPR(void){					// 端子機能選択許可
	MPC.PWPR.BIT.B0WI = 0; 				//PWPR.PFSWEライトプロテクト解除
	MPC.PWPR.BIT.PFSWE = 1;				//上記と組み合わせ端子機能選択可能にする。
}

void disable_PWPR(void){				//	端子機能選択禁止
	MPC.PWPR.BIT.B0WI = 1; 				//PWPR.PFSWEライトプロテクト設定
	MPC.PWPR.BIT.PFSWE = 0;				//上記と組み合わせ端子機能選択禁止にする。
}

/*
//************************************************************************
void initIrqSwitch(void){

	PORTH.PDR.BIT.B1 = 0;				// P3-0 を入力:P3-0，1はクロック発信用
	IEN(ICU, IRQ0) = 0;					// IRQ0を停止する
	PORTH.PDR.BIT.B2 = 0;				// P3-1 を入力
	IEN(ICU, IRQ1) = 0;					// IRQ1を停止する

	enable_PWPR();

	MPC.PH0PFS.BYTE = 0x40;				// PH0をIRQ0とする
	ICU.IRQCR[0].BIT.IRQMD = 1;			// 立ち下りエッジで割込
	IR(ICU,IRQ0) = 0;					// 割込ステータスクリア
	IPR(ICU,IRQ0) = 15;					// 割込優先度
	IEN(ICU, IRQ0) = 1;					// IRQ割込許可する
	ICU.IRQFLTE0.BIT.FLTEN0 = 1; 		//デジタルフィルタ許可
	MPC.PH1PFS.BYTE = 0x40;				// PH1をIRQ1とする
	ICU.IRQCR[1].BIT.IRQMD = 1;			// 立ち下りエッジで割込
	IR(ICU,IRQ1) = 0;					// 割込ステータスクリア
	IPR(ICU,IRQ1) = 15;					// 割込優先度
//	IEN(ICU, IRQ1) = 1;					// IRQ割込許可

	disable_PWPR();
}
*/

//-----------------------------------------------------------------------
//	LCD を初期化する
//-----------------------------------------------------------------------
void InitLcd(void)
{

	//	液晶表示用ポート設定
	PORTE.PDR.BIT.B4 = 1;
    PORTE.PDR.BIT.B5 = 1;
    PORTE.PDR.BIT.B0 = 1;
    PORTE.PDR.BIT.B1 = 1;
    PORTE.PDR.BIT.B2 = 1;
    PORTE.PDR.BIT.B3 = 1;
    //-----------------------------------------------------------------------
    //	LCD 初期化　と　表示消去
    //-----------------------------------------------------------------------
    wait(60000);			//	Delay
    wait(60000);			//	Delay
    wait(60000);			//	Delay
    wait(60000);			//	Delay
    EN = 0;
    RS = 0;
    PORTE.PODR.BYTE = 0x03;

    EN = 1;														// E = 'H'
    EN = 0;														// E = 'L'
    wait(7000);
    PORTE.PODR.BYTE = 0x03;

    EN = 1;														// E = 'H'
    EN = 0;														// E = 'L'
    wait(120);
    PORTE.PODR.BYTE = 0x03;

    EN = 1;														// E = 'H'
    EN = 0;														// E = 'L'
    wait(100);
    PORTE.PODR.BYTE = 0x02;

    EN = 1;														// E = 'H'
    EN = 0;														// E = 'L'
    wait(100);

    write_lcd(0x28,LCD_CMD);									//２桁
    wait(50);
    write_lcd(0x0C,LCD_CMD);									//表示オフ
    wait(50);
    write_lcd(0x01,LCD_CMD);									//表示クリア
    wait(2100);
    write_lcd(0x06,LCD_CMD);									//エントリーモード　インクリメント　シフトしない
    wait(50);
}


//----------------------------
// 液晶表示出力(4bit分割書込み)
void write_lcd(unsigned char code, unsigned char rs){
	unsigned char	code_hi;
	unsigned char	code_low;

	code_hi = (code >> 4);
	code_hi &= 0x0f;

 	PORTE.PODR.BYTE = code_hi;									// D4-D7 に設定

	if(rs)	RS = LCD_DATA;										// RSを設定 1は表示値
	else	RS = LCD_CMD;										//０は液晶の設定値を示す

	EN = 1;														// E = 'H'
	EN = 0;														// E = 'L'
	wait(50);

	code_low = (code &= 0x0f);

	PORTE.PODR.BYTE = code_low;									// D0-D3 に設定

	if(rs)	RS = 1;												// RSを設定
	else	RS = 0;

	EN = 1;														// E = 'H'
	EN = 0;														// E = 'L'
	wait(50);
}

//-----------------------------
// 液晶のカーソル位置を設定 x=桁　y:0=1行目,1=2行目
void	locate(int x, int y)
{
	if(y==1)		y=0;
	else if(y==2)	y=0x40;
	else if(y==3)	y=0x14;
	else if(y==4)	y=0x54;
	else			y=0;
	write_lcd(x+0x80+y,LCD_CMD);
	wait(100);
}

//-----------------------------
// 液晶に１文字送る
void	write_char(unsigned char c)
{
	write_lcd(c, LCD_DATA);
}

//----------------------------
// 液晶に文字列を送る
void	write_str(char *s)
{
	while(*s){									// 文字列の終わり(NULLコード)まで出力する
		write_lcd(*s, LCD_DATA);
		s++;
	}
}
//*******************************************

//*******************************************
void wait( unsigned int loop) {					//2000=5.5mS 39200=104mS  2.75μsec/1cycle
	volatile unsigned int	i;
	volatile unsigned int	dummy;
	for (i=0;i < loop;i++) {
	dummy++;
	}
}

   	//************************************************************************
   	//数値ー>文字変換　char out_str[10];を用意しておく
   	//************************************************************************
void itoa(char out_str[],unsigned int in_i)
   	{
   	int n0,n1,n2,n3,n4;
   	int lp,chk;

   	// 1.Convert Integer to Strings	４桁表示に対応
   	    n0 =  in_i / 1000         ;
   	    n1 = (in_i % 1000) / 100 ;
   	    n2 = (in_i % 100)  /  10 ;
   	    n3 = (in_i %  10)  /   1;

   	    out_str[0] = (unsigned char)n0 | 0x30;
   	    out_str[1] = (unsigned char)n1 | 0x30;
   	    out_str[2] = (unsigned char)n2 | 0x30;
   	    out_str[3] = (unsigned char)n3 | 0x30;
   	    out_str[5] = 0x00;
   	//  return;

   	// 2.Zero sus
   	    chk=3;
   	    for(lp=0;lp<4;lp++){
   	        if(out_str[lp]!='0'){
   	            chk=lp;
   	            break;
   	        }
   	    }
   	    //  out_str[0]='0';
   	    if(chk>3)chk=3;
   	    for(lp=0;lp<chk;lp++){
   	        out_str[lp]=0x20;
   	    }
}

void clockset(void){						//メインクロック設定
   	SYSTEM.PRCR.WORD = 0xa50b; 			//システムプロテクト解除（クロックを選択可能にする）
   	SYSTEM.SCKCR.BIT.PCKB = 0x01; 		//周辺モジュールのクロックはシステムクロックの2分周とにする
   	SYSTEM.SCKCR.BIT.ICK = 0x00; 		//システムクロックはデフォルト設定：１分周とする

   	SYSTEM.MOSCCR.BYTE = 0;				//メインクロック発振器動作
   	SYSTEM.SOSCCR.BYTE = 0;				//サブクロック発振器動作
   	SYSTEM.SCKCR3.WORD = 0x0200;		//システムクロックにメインクロック発振器を使用する。

   	//	内臓発振器を使用する場合
   	//	SYSTEM.SCKCR3.BIT.CKSEL=1;		//HOCOをクロックソースに設定
   	//	SYSTEM.HOCOCR.BIT.HCSTP = 0;	//HOCO動作
   	//	SYSTEM.HOCOCR2.BIT.HCFRQ = 0;	//HOCOのク ロック選択 0**32MHz

   	SYSTEM.PRCR.WORD = 0xa500;			//システムプロテクト設定（クロックを変更不可にする）
}

    	//****************************************************************************
    	//*****************************************************
void init_adc(){
    //Port設定
    PORT4.PMR.BYTE = 0x07;                  //Port40,41,42を周辺機能とする
//    PORT4.PDR.BYTE = 0x00;                  //入力端子

	SYSTEM.PRCR.WORD = 0xa50b; 				//システムプロテクトの解除 クロックを選択可能にする(0xa502：第２ビットを上げれば良い）
    SYSTEM.MSTPCRA.BIT.MSTPA17 = 0; 		//S12ADモジュールを有効化:AD変換可能
	SYSTEM.PRCR.WORD = 0xa500; 				//システムプロテクトを変更禁止に戻す

    S12AD.ADCSR.BIT.ADCS = 0x0;             //シングルスキャンモード
    S12AD.ADANSA.WORD = 0x0007;             //AN000-003を有効にする
    S12AD.ADSSTR0 = 0xFF;                   //サンプリング時間255ADCLKクロック(=10us，多分)
//    S12AD.ADCSR.BIT.ADST = 0x1;             //AD変換スタート
}

void init_CMT(void){
	SYSTEM.PRCR.WORD = 0xa50b; 				//システムレジスターをプロテクトの解除 （変更可能にする）
	SYSTEM.MSTPCRA.BIT.MSTPA15 = 0;			//CMT0有効化
	CMT0.CMCOR = 10000;						//19532;
	CMT0.CMCR.BIT.CKS = 3;					//512分周

	IEN(CMT0,CMI0) = 1;
	IPR(CMT0,CMI0) = 5;
	CMT0.CMCR.BIT.CMIE = 1;					//割り込み許可

	SYSTEM.PRCR.WORD = 0xa500; 				//システムレジスターを変更不可にする
}

void MTUset(void){

    SYSTEM.PRCR.WORD = 0xa50b; 				//システムレジスターをプロテクトの解除 （変更可能にする）
    SYSTEM.MSTPCRA.BIT.MSTPA9 = 0; 			//MTU機能を有効化する



//	MTUch0の設定
    PORTB.PMR.BIT.B3 = 1;					//PB3端子を周辺機器端子として使用する
    MPC.PB3PFS.BIT.PSEL = 1;				//PB3端子をMTIOC0Aに割り当てる

    MTU0.TCR.BIT.TPSC = 0;    				//周辺モジュールクロックの1分周
    MTU0.TCR.BIT.CKEG = 0;    				//立ち下がりエッジ
    MTU0.TCR.BIT.CCLR = 1;    				//TGRAのコンペアマッチでTCNTクリア

    MTU0.TMDR.BIT.MD = 0x02;    			//PWMモード1で動作
    MTU0.TMDR.BIT.BFB = 1;        			//TGRBとTGRDはTGRAとTGRCのバッファとして動作

    MTU0.TIORH.BIT.IOA = 6;					//0110 H-H
    MTU0.TIORH.BIT.IOB = 5;					//0101 H-L
    MTU0.TGRA = CYCLETIME;					//周期設定 1.33kHz固定

    MTU0.TBTM.BIT.TTSB = 1; 				//メインデューティ：TGRD->B　の転送タイミングはTCNTクリア時

//    MTU.TSTR.BIT.CST0 = 1;				//カウントスタート

//	MTUch3の設定
    IEN(MTU3,TGIA3) = 1;					//割り込み許可
    IPR(MTU3,TGIA3) = 10;
    IEN(MTU3,TGIB3) = 1;
    IPR(MTU3,TGIB3) = 10;
    MTU3.TIER.BIT.TGIEA = 1;
    MTU3.TIER.BIT.TGIEB = 1;				//割り込み許可ここまで

   	PORT1.PMR.BIT.B4 = 1;					//P14端子を周辺機器端子として使用する
    MPC.P14PFS.BIT.PSEL = 1;				//P14端子をMTIOC3Aに割り当てる

    MTU3.TCR.BIT.TPSC = 5;    				//周辺モジュールクロックの1024分周
    MTU3.TCR.BIT.CKEG = 1;    				//立ち上がりエッジ
    MTU3.TCR.BIT.CCLR = 1;    				//TGRAのコンペアマッチでTCNTクリア

    MTU3.TMDR.BIT.MD = 0x02;    			// PWMモード1で動作
    MTU3.TMDR.BIT.BFA = 1;        			//TGRAとTGRCはバッファ動作
    MTU3.TMDR.BIT.BFB = 1;        			//TGRBとTGRDはバッファ動作

    MTU3.TIORH.BIT.IOA = 6;        			//0110   H-H
    MTU3.TIORH.BIT.IOB = 5;        			//0101	H-L
    MTU3.TGRA = 50;        				//初期周期設定（仮）

    MTU3.TBTM.BIT.TTSB = 1; 				//TGRC->A　の転送タイミング　TCNTクリア時
//    MTU.TSTR.BIT.CST3 = 1;        		//ユニット3動作開始


    SYSTEM.PRCR.WORD = 0xa500; 				//システムレジスターを変更不可にする
}

void enable_functionselect(void){			// 端子機能選択許可
	MPC.PWPR.BIT.B0WI = 0; 					//PWPR.PFSWEライトプロテクト解除
	MPC.PWPR.BIT.PFSWE = 1;					//上記と組み合わせ端子機能選択可能にする。
}

void disable_functionselect(void){			//	端子機能選択禁止
	MPC.PWPR.BIT.B0WI = 1; 					//PWPR.PFSWEライトプロテクト設定
	MPC.PWPR.BIT.PFSWE = 0;					//上記と組み合わせ端子機能選択禁止にする。
}
